/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.controller;

import br.com.linkcom.neo.bean.editors.FileEditor;
import br.com.linkcom.neo.controller.BindExceptionNeo;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.types.File;
import java.beans.PropertyEditor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;

public class ServletRequestDataBinderNeo
extends ServletRequestDataBinder {
    public static final String EXCLUDE = "_excludeField";
    public static final String DATE_PATTERN = "_datePattern";
    private static final String OBJECT_VALUE_REGEX = "((.*\\.)*\\w*)\\[(.*)\\]";

    public ServletRequestDataBinderNeo(Object target, String objectName) {
        super(target, objectName);
    }

    protected BindException createErrors(Object target, String objectName) {
        return new BindExceptionNeo(target, objectName);
    }

    protected void doBind(MutablePropertyValues mpvs) {
        Class[] classes;
        PropertyEditor customEditor = this.getBeanWrapper().findCustomEditor(File.class, null);
        if (customEditor == null && (classes = Neo.getApplicationContext().getClassManager().getAllClassesOfType(File.class)).length == 1) {
            FileEditor fileEditor = new FileEditor(){

                protected File createFile(Object value) {
                    try {
                        return (File)classes[0].newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            this.registerCustomEditor(classes[0], (PropertyEditor)((Object)fileEditor));
        }
        PropertyValue[] propertyValues = mpvs.getPropertyValues();
        int i = 0;
        while (i < propertyValues.length) {
            PropertyValue propertyValue = propertyValues[i];
            if (propertyValue.getName().endsWith(DATE_PATTERN)) {
                this.extractDatePattern(mpvs, propertyValue);
            }
            ++i;
        }
        i = 0;
        while (i < propertyValues.length) {
            PropertyValue value = propertyValues[i];
            if (ServletRequestDataBinderNeo.isObjectValue(value.getValue())) {
                Object translatedObjectValue = ServletRequestDataBinderNeo.translateObjectValue(value.getName(), value.getValue(), mpvs);
                mpvs.addPropertyValue(value.getName(), translatedObjectValue);
                if (translatedObjectValue == null) {
                    propertyValues = mpvs.getPropertyValues();
                    i = -1;
                }
            } else if (this.isObjectArrayValue(value.getValue())) {
                mpvs.addPropertyValue(value.getName(), this.translateObjectArrayValue(value.getName(), value.getValue()));
            }
            ++i;
        }
        super.doBind(mpvs);
    }

    public static Object translateObjectValue(String name, Object value, MutablePropertyValues mpvs) {
        if ("<null>".equals(value)) {
            if (mpvs == null) {
                return null;
            }
            PropertyValue[] propertyValues = mpvs.getPropertyValues();
            int i = 0;
            while (i < propertyValues.length) {
                if (propertyValues[i].getName().startsWith(String.valueOf(name) + ".")) {
                    mpvs.removePropertyValue(propertyValues[i]);
                }
                ++i;
            }
            return null;
        }
        String valueString = value.toString();
        Pattern pattern = Pattern.compile(OBJECT_VALUE_REGEX);
        Matcher matcher = pattern.matcher(valueString);
        Object resultado = null;
        if (matcher.find()) {
            Class<?> clazz;
            String nomeClasse = matcher.group(1);
            String nameValuesString = matcher.group(3);
            PropertyValues properties = ServletRequestDataBinderNeo.getPropertyValues(nameValuesString);
            try {
                clazz = Class.forName(nomeClasse);
            }
            catch (ClassNotFoundException e) {
                throw new NeoException("N\u00e3o foi poss\u00edvel instanciar classe [" + nomeClasse + "] da propriedade " + name, e);
            }
            if (mpvs == null) {
                resultado = ServletRequestDataBinderNeo.createObject(properties, clazz);
            } else {
                PropertyValue[] propertyValues;
                PropertyValue[] propertyValueArray = propertyValues = properties.getPropertyValues();
                int n = propertyValues.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyValue pv = propertyValueArray[n2];
                    PropertyValue propertyValue = new PropertyValue(String.valueOf(name) + "." + pv.getName(), pv.getValue());
                    mpvs.addPropertyValue(propertyValue);
                    ++n2;
                }
                resultado = ServletRequestDataBinderNeo.createObject(properties, clazz);
            }
        }
        return resultado;
    }

    public static Object createObject(PropertyValues properties, Class clazz) {
        Object resultado = BeanUtils.instantiateClass((Class)clazz);
        ServletRequestDataBinderNeo binder = new ServletRequestDataBinderNeo(resultado, null);
        binder.bind(properties);
        return resultado;
    }

    private static PropertyValues getPropertyValues(String nameValuesString) {
        MutablePropertyValues properties = new MutablePropertyValues();
        StringTokenizer tokenizer = new StringTokenizer(nameValuesString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String[] nameValuePair = token.trim().split("=");
            PropertyValue propertyValue = new PropertyValue(nameValuePair[0], (Object)nameValuePair[1]);
            properties.addPropertyValue(propertyValue);
        }
        return properties;
    }

    public static boolean isObjectValue(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            if (string.equals("<null>")) {
                return true;
            }
            char[] toCharArray = string.toCharArray();
            if (toCharArray.length > 3) {
                boolean temColchetes = false;
                int i = 0;
                while (i < toCharArray.length) {
                    if (toCharArray[i] == '[') {
                        temColchetes = true;
                        break;
                    }
                    if (toCharArray[i] == ' ') {
                        return false;
                    }
                    ++i;
                }
                i = toCharArray.length - 1;
                while (toCharArray[i] == ' ') {
                    --i;
                }
                if (toCharArray[i] != ']') {
                    return false;
                }
                if (!temColchetes) {
                    return false;
                }
            } else {
                return false;
            }
            if ((string.matches(OBJECT_VALUE_REGEX) || "<null>".equals(string)) && !string.contains("#")) {
                return true;
            }
        }
        return false;
    }

    private boolean isObjectArrayValue(Object value) {
        Object svalue;
        return value != null && value.getClass().isArray() && ((Object[])value).length > 0 && (svalue = ((Object[])value)[0]) instanceof String && (svalue.toString().matches(OBJECT_VALUE_REGEX) || "<null>".equals(svalue));
    }

    private Object translateObjectArrayValue(String name, Object value) {
        Object[] array;
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] objectArray = array = (Object[])value;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            list.add(ServletRequestDataBinderNeo.translateObjectValue(name, object, null));
            ++n2;
        }
        return list.toArray();
    }

    protected void checkFieldMarkers(MutablePropertyValues mpvs) {
        PropertyValue[] propertyValues;
        super.checkFieldMarkers(mpvs);
        PropertyValue[] propertyValueArray = propertyValues = mpvs.getPropertyValues();
        int n = propertyValues.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyValue propertyValue = propertyValueArray[n2];
            Pattern compile = Pattern.compile("(.*)_excludeField");
            Matcher matcher = compile.matcher(propertyValue.getName());
            if (matcher.matches() && new Boolean((String)propertyValue.getValue()).booleanValue()) {
                String fieldName = matcher.group(1);
                mpvs.removePropertyValue(fieldName);
            }
            ++n2;
        }
    }

    private void extractDatePattern(MutablePropertyValues mpvs, PropertyValue propertyValue) {
        String dateProperty = propertyValue.getName().substring(0, propertyValue.getName().length() - DATE_PATTERN.length());
        PropertyValue pv = mpvs.getPropertyValue(dateProperty);
        if (pv.getValue() != null && pv.getValue() instanceof String) {
            String dataString = (String)pv.getValue();
            SimpleDateFormat dateFormat = new SimpleDateFormat((String)propertyValue.getValue());
            try {
                mpvs.addPropertyValue(new PropertyValue(dateProperty, (Object)dateFormat.parse(dataString)));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }
}

