/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.bean.editors;

import br.com.linkcom.neo.types.Money;
import java.beans.PropertyEditorSupport;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.apache.commons.lang.StringUtils;

public class MoneyPropertyEditor
extends PropertyEditorSupport {
    public void setAsText(String text) throws IllegalArgumentException {
        if (!StringUtils.isEmpty((String)text)) {
            try {
                text = text.replace(".", "");
                text = text.replace(',', '.');
                this.setValue(new Money(text));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.setValue(null);
        }
    }

    public String getAsText() {
        if (this.getValue() == null) {
            return null;
        }
        Money money = (Money)this.getValue();
        BigDecimal value = money.getValue();
        DecimalFormat numberFormat = new DecimalFormat("#,##0.00");
        return numberFormat.format(value);
    }
}

