/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.bean.editors;

import br.com.linkcom.neo.types.Hora;
import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class HoraPropertyEditor
extends PropertyEditorSupport {
    private String pattern = "HH:mm";
    private DateFormat dateFormat = new SimpleDateFormat(this.pattern);
    private boolean lenient = false;

    public HoraPropertyEditor() {
    }

    public HoraPropertyEditor(String pattern) {
        this.pattern = pattern;
        this.dateFormat = new SimpleDateFormat(this.pattern);
    }

    public HoraPropertyEditor(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public Object getValue() {
        Object object = super.getValue();
        if (object instanceof Date) {
            Hora hora = new Hora(((Date)object).getTime());
            return hora;
        }
        return object;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text != null && !text.trim().equals("")) {
            try {
                this.dateFormat.setLenient(this.lenient);
                Hora hora = new Hora(this.dateFormat.parse(text).getTime());
                this.setValue(hora);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.setValue(null);
        }
    }

    public String getAsText() {
        if (this.getValue() == null) {
            return "";
        }
        return this.dateFormat.format((Hora)this.getValue());
    }
}

