/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.bean;

import br.com.linkcom.neo.bean.annotation.DisplayName;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import br.com.linkcom.neo.util.Util;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class DisplayNameUtil {
    static Map<Class, String> cacheClassDisplayName = new HashMap<Class, String>();
    static Map<Class, Map<String, String>> cachePropertyDisplayName = new HashMap<Class, Map<String, String>>();
    static boolean neverReload = false;
    static long lastRead = 0L;

    public static String getDisplayName(Class clazz) {
        String displayName;
        boolean reloadCache = DisplayNameUtil.reloadCache();
        if (reloadCache) {
            cacheClassDisplayName = new HashMap<Class, String>();
        }
        if ((displayName = null) == null) {
            ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
            if (reflectionCache.isAnnotationPresent(clazz, DisplayName.class)) {
                displayName = reflectionCache.getAnnotation(clazz, DisplayName.class).value();
            }
            if (displayName == null) {
                String[] names = new String[]{clazz.getName(), clazz.getSimpleName(), Util.strings.uncaptalize(clazz.getSimpleName())};
                int i = 0;
                while (i < names.length) {
                    displayName = Util.locale.getBundleKey(names[i]);
                    if (displayName != null) break;
                    ++i;
                }
            }
            if (displayName == null) {
                displayName = Util.strings.separateOnCase(clazz.getSimpleName());
            }
            cacheClassDisplayName.put(clazz, displayName);
        }
        return displayName;
    }

    public static String getDisplayName(Class clazz, String propertyName, Annotation[] annotations) {
        String displayName;
        Map<String, String> map;
        boolean reloadCache = DisplayNameUtil.reloadCache();
        if (reloadCache) {
            cachePropertyDisplayName = new HashMap<Class, Map<String, String>>();
        }
        if ((map = cachePropertyDisplayName.get(clazz)) == null) {
            map = new HashMap<String, String>();
            cachePropertyDisplayName.put(clazz, map);
        }
        if ((displayName = null) == null) {
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation anno = annotationArray[n2];
                if (DisplayName.class.isAssignableFrom(anno.annotationType())) {
                    displayName = ((DisplayName)anno).value();
                }
                ++n2;
            }
            if (displayName == null) {
                String[] names = new String[]{String.valueOf(clazz.getName()) + "." + propertyName, String.valueOf(clazz.getSimpleName()) + "." + propertyName, String.valueOf(Util.strings.uncaptalize(clazz.getSimpleName())) + "." + propertyName, propertyName};
                int i = 0;
                while (i < names.length) {
                    displayName = Util.locale.getBundleKey(names[i]);
                    if (displayName != null) break;
                    ++i;
                }
            }
            if (displayName == null) {
                displayName = Util.strings.separateOnCase(Util.strings.captalize(propertyName));
            }
            map.put(propertyName, displayName);
        }
        return displayName;
    }

    public static boolean reloadCache() {
        return true;
    }
}

