/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.bean;

import br.com.linkcom.neo.bean.AnnotatedBeanRegister;
import br.com.linkcom.neo.bean.annotation.Bean;
import br.com.linkcom.neo.bean.annotation.Property;
import br.com.linkcom.neo.bean.annotation.Ref;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanRegisterBean
implements AnnotatedBeanRegister {
    protected int autowire = 4;
    protected Log log = LogFactory.getLog((String)"BeanRegister");

    @Override
    public Class<? extends Annotation> getAnnotationClass() {
        return Bean.class;
    }

    @Override
    public void registerBeans(List<Class<?>> annotatedClasses, DefaultListableBeanFactory beanFactory) {
        for (Class<?> annotatedClass : annotatedClasses) {
            this.log.debug((Object)("Registrando bean automaticamente ... " + annotatedClass.getName()));
            this.registerBean(beanFactory, annotatedClass);
        }
    }

    protected void registerBean(DefaultListableBeanFactory beanFactory, Class<?> class1) {
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        Bean bean = reflectionCache.getAnnotation(class1, Bean.class);
        this.registerBean(beanFactory, class1, bean);
    }

    protected void registerBean(DefaultListableBeanFactory beanFactory, Class<?> class1, Bean bean) {
        MutablePropertyValues mutablePropertyValues = this.createPropertyValues(class1, bean);
        RootBeanDefinition beanDefinition = this.createBeanDefinition(class1, mutablePropertyValues);
        beanDefinition.setAutowireMode(this.autowire);
        String beanName = this.getBeanName(class1, bean);
        beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    protected RootBeanDefinition createBeanDefinition(Class<?> class1, MutablePropertyValues mutablePropertyValues) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(class1, mutablePropertyValues);
        return beanDefinition;
    }

    protected MutablePropertyValues createPropertyValues(Class<?> class1, Bean bean) {
        Method[] methods;
        Property[] beanProperties;
        MutablePropertyValues mutablePropertyValues = new MutablePropertyValues();
        Property[] propertyArray = beanProperties = bean.properties();
        int n = beanProperties.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            String propvalue = null;
            String value = property.value();
            if (!StringUtils.isEmpty((String)value)) {
                propvalue = value.equals("null") ? null : value;
            } else if (!StringUtils.isEmpty((String)property.ref())) {
                propvalue = property.ref().equals("null") ? null : new RuntimeBeanReference(property.ref());
            } else {
                throw new RuntimeException("A classe " + class1.getName() + " n\u00e3o declarou o atributo beanProperties corretamente, ref ou value devem ser informados em cada beanProperty. Erro na propriedade: " + property.name());
            }
            if (!StringUtils.isEmpty((String)value) && !StringUtils.isEmpty((String)property.ref())) {
                throw new RuntimeException("A classe " + class1.getName() + " n\u00e3o declarou o atributo beanProperties corretamente, somente ref ou value deve ser informado em cada beanProperty. Erro na propriedade: " + property.name());
            }
            mutablePropertyValues.addPropertyValue(property.name(), (Object)propvalue);
            ++n2;
        }
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        Method[] methodArray = methods = reflectionCache.getMethods(class1);
        int n3 = methods.length;
        int n4 = 0;
        while (n4 < n3) {
            Method method = methodArray[n4];
            if (method.getName().startsWith("set")) {
                String propertyName = StringUtils.uncapitalize((String)method.getName().substring(3));
                Ref refAnnotation = method.getAnnotation(Ref.class);
                if (refAnnotation != null) {
                    String name = null;
                    if (!StringUtils.isEmpty((String)refAnnotation.bean())) {
                        name = refAnnotation.bean();
                    }
                    if ("<null>".equals(name)) {
                        mutablePropertyValues.addPropertyValue(propertyName, null);
                    } else if (this.autowire != 0) {
                        if (name != null) {
                            mutablePropertyValues.addPropertyValue(propertyName, (Object)new RuntimeBeanReference(name));
                        }
                    } else {
                        if (name == null) {
                            name = propertyName;
                        }
                        mutablePropertyValues.addPropertyValue(propertyName, (Object)new RuntimeBeanReference(name));
                    }
                }
            }
            ++n4;
        }
        return mutablePropertyValues;
    }

    public String getBeanName(Class<?> class1, Bean bean) {
        String beanName = bean.name();
        if (StringUtils.isEmpty((String)beanName)) {
            beanName = StringUtils.uncapitalize((String)class1.getSimpleName());
        }
        return beanName;
    }

    @Override
    public String getName(Class<?> clazz) {
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        Bean bean = reflectionCache.getAnnotation(clazz, Bean.class);
        return this.getBeanName(clazz, bean);
    }
}

