/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.authorization.impl;

import br.com.linkcom.neo.authorization.AuthorizationDAO;
import br.com.linkcom.neo.authorization.Role;
import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.authorization.UserLocator;
import br.com.linkcom.neo.core.standard.RequestContext;
import br.com.linkcom.neo.core.web.DefaultWebRequestContext;
import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.view.menu.MenuTag;
import java.security.Principal;

public class UserLocatorImpl
implements UserLocator {
    protected AuthorizationDAO authorizationDAO;

    public AuthorizationDAO getAuthorizationDAO() {
        return this.authorizationDAO;
    }

    public void setAuthorizationDAO(AuthorizationDAO authorizationDAO) {
        this.authorizationDAO = authorizationDAO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public User getUser(RequestContext request) {
        User user = request.getUser();
        if (user != null) return user;
        Principal userPrincipal = ((WebRequestContext)request).getUserPrincipal();
        if (userPrincipal != null) {
            String username = userPrincipal.getName();
            if (username == null) throw new RuntimeException("Erro inesperado: Algoritmo inv\u00e1lido em UserLocatorImpl");
            user = this.authorizationDAO.findUserByLogin(username);
            if (request instanceof WebRequestContext) {
                ((WebRequestContext)request).getSession().setAttribute(MenuTag.MENU_CACHE_MAP, null);
            }
            if (user == null) {
                throw new NeoException("Usu\u00e1rio n\u00e3o encontrado no banco de dados: " + username);
            }
        } else {
            user = null;
        }
        ((DefaultWebRequestContext)request).setUser(user);
        return user;
    }

    public void loadPermissions(WebRequestContext requestContext) {
        User user;
        if (requestContext.getSession().getAttribute("NEO_LOADPERMISSIONS") == null && (user = this.getUser(requestContext)) != null) {
            Role[] findUserRoles;
            Role[] roleArray = findUserRoles = this.authorizationDAO.findUserRoles(user);
            int n = findUserRoles.length;
            int n2 = 0;
            while (n2 < n) {
                Role role = roleArray[n2];
                requestContext.getSession().setAttribute("PAPEL_" + role.getName().toUpperCase(), (Object)true);
                ++n2;
            }
            requestContext.getSession().setAttribute("NEO_LOADPERMISSIONS", (Object)true);
        }
    }
}

