/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.authorization.impl;

import br.com.linkcom.neo.authorization.AuthorizationDAO;
import br.com.linkcom.neo.authorization.AuthorizationItem;
import br.com.linkcom.neo.authorization.AuthorizationModule;
import br.com.linkcom.neo.authorization.Permission;
import br.com.linkcom.neo.authorization.PermissionLocator;
import br.com.linkcom.neo.authorization.Role;
import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.controller.ControlMapping;
import br.com.linkcom.neo.core.standard.RequestContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionLocatorImpl
implements PermissionLocator {
    static Log log = LogFactory.getLog(PermissionLocator.class);
    private static final String CACHE_ROLES = "CACHE_ROLES";
    protected AuthorizationDAO authorizationDAO;
    Map<ControlMapping, Map<Role, Permission>> cache = new HashMap<ControlMapping, Map<Role, Permission>>();

    public void setAuthorizationDAO(AuthorizationDAO authorizationDAO) {
        this.authorizationDAO = authorizationDAO;
    }

    @Override
    public synchronized Permission[] getPermissions(RequestContext request, User user, ControlMapping control) {
        Map<User, Role[]> cacheRoles = this.getCacheRoles(request);
        Role[] userRoles = cacheRoles.get(user);
        if (userRoles == null) {
            userRoles = this.authorizationDAO.findUserRoles(user);
            cacheRoles.put(user, userRoles);
        }
        Permission[] permissions = new Permission[userRoles.length];
        int i = 0;
        while (i < userRoles.length) {
            block5: {
                Role role;
                String controlName;
                block4: {
                    Map<Role, Permission> mapRolePermission;
                    block3: {
                        controlName = control.getName();
                        role = userRoles[i];
                        mapRolePermission = this.cache.get(control);
                        if (mapRolePermission == null) break block3;
                        Permission permission = mapRolePermission.get(role);
                        if (permission == null) break block4;
                        log.debug((Object)("Using cached permission: " + permission));
                        permissions[i] = permission;
                        break block5;
                    }
                    mapRolePermission = new HashMap<Role, Permission>();
                    this.cache.put(control, mapRolePermission);
                }
                permissions[i] = this.authorizationDAO.findPermission(role, controlName);
                if (permissions[i] == null) {
                    AuthorizationModule authorizationModule = control.getAuthorizationModule();
                    Map<String, String> defaultPermissionMap = this.getDefaultPermissionMap(authorizationModule);
                    log.debug((Object)("Criando permissao... control=" + controlName + ", role=" + role.getName()));
                    permissions[i] = this.authorizationDAO.savePermission(controlName, role, defaultPermissionMap);
                }
                this.cache.get(control).put(role, permissions[i]);
            }
            ++i;
        }
        return permissions;
    }

    private Map<User, Role[]> getCacheRoles(RequestContext request) {
        HashMap cache = (HashMap)request.getUserAttribute(CACHE_ROLES);
        if (cache == null) {
            cache = new HashMap();
            request.setUserAttribute(CACHE_ROLES, cache);
        }
        return cache;
    }

    private Map<String, String> getDefaultPermissionMap(AuthorizationModule authorizationModule) {
        AuthorizationItem[] authorizationItens = authorizationModule.getAuthorizationItens();
        HashMap<String, String> defaultPermissionMap = new HashMap<String, String>();
        AuthorizationItem[] authorizationItemArray = authorizationItens;
        int n = authorizationItens.length;
        int n2 = 0;
        while (n2 < n) {
            AuthorizationItem item = authorizationItemArray[n2];
            String id = item.getId();
            if (item.getValores() == null || item.getValores().length == 0) {
                throw new IllegalArgumentException("Os valores poss\u00edveis de um item de autoriza\u00e7\u00e3o n\u00e3o pode ser um array vazio ou null");
            }
            String valorMaisRestritivo = item.getValores()[item.getValores().length - 1];
            defaultPermissionMap.put(id, valorMaisRestritivo);
            ++n2;
        }
        return defaultPermissionMap;
    }

    public synchronized void reset() {
        this.cache = new HashMap<ControlMapping, Map<Role, Permission>>();
    }

    @Override
    public void clearCache() {
        this.reset();
    }
}

