/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.authorization.impl;

import br.com.linkcom.neo.authorization.Authorization;
import br.com.linkcom.neo.authorization.AuthorizationManager;
import br.com.linkcom.neo.authorization.AuthorizationModule;
import br.com.linkcom.neo.authorization.HasAccessAuthorizationModule;
import br.com.linkcom.neo.authorization.Permission;
import br.com.linkcom.neo.authorization.PermissionLocator;
import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.authorization.UserLocator;
import br.com.linkcom.neo.controller.ControlMapping;
import br.com.linkcom.neo.controller.ControlMappingLocator;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.core.standard.RequestContext;
import br.com.linkcom.neo.core.web.WebRequestContext;

public class AuthorizationManagerImpl
implements AuthorizationManager {
    public static final String ACTION_PARAMETER = "ACAO";
    protected UserLocator userLocator;
    protected PermissionLocator permissionLocator;
    protected ControlMappingLocator controlMappingLocator;

    public void setControlMappingLocator(ControlMappingLocator controlMappingLocator) {
        this.controlMappingLocator = controlMappingLocator;
    }

    public void setPermissionLocator(PermissionLocator permissionLocator) {
        this.permissionLocator = permissionLocator;
    }

    public void setUserLocator(UserLocator userLocator) {
        this.userLocator = userLocator;
    }

    public boolean isAutorized(RequestContext request) {
        String actionParameter = request.getParameter(ACTION_PARAMETER);
        User usuario = this.userLocator.getUser(request);
        String path = request.getRequestQuery();
        ControlMapping controlMapping = this.controlMappingLocator.getControlMapping(path);
        return this.isAuthorized(request, actionParameter, usuario, this.permissionLocator, controlMapping);
    }

    public boolean isAuthorized(RequestContext request, String actionParameter, User usuario, PermissionLocator permissionLocator, ControlMapping controlMapping) {
        boolean isAuthorized;
        if (controlMapping == null || controlMapping.getAuthorizationModule() == null || controlMapping.getAuthorizationModule() instanceof HasAccessAuthorizationModule) {
            isAuthorized = true;
        } else {
            Authorization autorizacao = this.createAuthorization(request, usuario, permissionLocator, controlMapping);
            AuthorizationModule moduloAutorizacao = controlMapping.getAuthorizationModule();
            isAuthorized = moduloAutorizacao.isAuthorized(actionParameter, autorizacao);
            request.setAttribute("authorization", autorizacao);
        }
        return isAuthorized;
    }

    public boolean isAuthorized(String path, String actionParameter, RequestContext request) {
        User user = this.userLocator.getUser(request);
        return this.isAuthorized(path, actionParameter, user);
    }

    public boolean isAuthorized(String path, String actionParameter, User usuario) {
        ControlMapping controlMapping = this.controlMappingLocator.getControlMapping(path);
        return this.isAuthorized(Neo.getRequestContext(), actionParameter, usuario, this.permissionLocator, controlMapping);
    }

    private Authorization createAuthorization(RequestContext request, User usuario, PermissionLocator permissionLocator, ControlMapping controlMapping) {
        Permission[] permissoes = usuario != null ? permissionLocator.getPermissions(request, usuario, controlMapping) : new Permission[]{};
        Authorization autorizacao = controlMapping.getAuthorizationModule().createAuthorization(permissoes);
        return autorizacao;
    }

    public void loadPermissions(WebRequestContext requestContext) {
        this.userLocator.loadPermissions(requestContext);
    }
}

