/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.authorization.crud;

import br.com.linkcom.neo.authorization.Authorization;
import br.com.linkcom.neo.authorization.Authorizer;
import br.com.linkcom.neo.authorization.crud.CrudAuthorization;
import br.com.linkcom.neo.exception.AuthorizationException;

public class CrudAuthorizer
implements Authorizer {
    protected static final String ACTION_CRIAR = "criar";
    protected static final String ACTION_EDITAR = "editar";
    protected static final String ACTION_SALVAR = "salvar";
    protected static final String ACTION_EXCLUIR = "excluir";
    protected static final String ACTION_ENTRADA = "entrada";
    protected static final String ACTION_LISTAGEM = null;
    protected static final String METODO_CRIAR = "doCriar";
    protected static final String METODO_EDITAR = "doEditar";
    protected static final String METODO_SALVAR = "doSalvar";
    protected static final String METODO_EXCLUIR = "doExcluir";
    protected static final String METODO_ENTRADA = "doEntrada";
    private static CrudAuthorizer instancia;

    private CrudAuthorizer() {
    }

    public static CrudAuthorizer getInstance() {
        if (instancia == null) {
            instancia = new CrudAuthorizer();
        }
        return instancia;
    }

    public boolean isAuthorized(String acao, Authorization autorizacao) {
        if (!(autorizacao instanceof CrudAuthorization)) {
            throw new AuthorizationException("O tipo da autorizacao usada pela classe AutorizadorCrud deve ser do tipo AutorizacaoCrud");
        }
        CrudAuthorization autorizacaoCrud = (CrudAuthorization)autorizacao;
        if (acao == null || acao.equals("") || acao.equals("listagem") || acao.equals("doListagem") || acao.equals("consultar") || acao.equals("doConsultar")) {
            return autorizacaoCrud.canRead();
        }
        if (acao.equals(ACTION_CRIAR) || acao.equals(METODO_CRIAR)) {
            return autorizacaoCrud.canCreate();
        }
        if (acao.equals(ACTION_EDITAR) || acao.equals(METODO_EDITAR)) {
            return autorizacaoCrud.canUpdate();
        }
        if (acao.equals(ACTION_SALVAR) || acao.equals(ACTION_ENTRADA) || acao.equals(METODO_SALVAR) || acao.equals(METODO_ENTRADA)) {
            return autorizacaoCrud.canCreate() || autorizacaoCrud.canUpdate();
        }
        if (acao.equals(ACTION_EXCLUIR) || acao.equals(METODO_EXCLUIR)) {
            return autorizacaoCrud.canDelete();
        }
        return true;
    }
}

